Imports Microsoft.VisualBasic.CompilerServices
Imports System
Imports System.Collections
Imports System.Runtime.CompilerServices
Imports System.Runtime.InteropServices
Imports System.Threading


Namespace CF_Full_Screen_Programm
    Public Class API
        Public Event WindowFound As WindowFoundEventHandler

        <DllImport("user32", EntryPoint:="FindWindow", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfFindWindow(<MarshalAs(UnmanagedType.VBByRefStr)> ByRef lpClassName As String, <MarshalAs(UnmanagedType.VBByRefStr)> ByRef lpWindowName As String) As Integer
        End Function

        <DllImport("user32", EntryPoint:="FindWindowEx", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfFindWindowEx(ByVal hWnd1 As Integer, ByVal hWnd2 As Integer, <MarshalAs(UnmanagedType.VBByRefStr)> ByRef lpsz1 As String, <MarshalAs(UnmanagedType.VBByRefStr)> ByRef lpsz2 As String) As Integer
        End Function

        <DllImport("user32.dll", EntryPoint:="GetParent", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfGetParent(ByVal hwnd As Integer) As Integer
        End Function

        <DllImport("user32.dll", EntryPoint:="MoveWindow", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfMoveWindow(ByVal hwnd As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal bRepaint As Integer) As Integer
        End Function

        <DllImport("user32.dll", EntryPoint:="PostMessageA", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfPostMessage(ByVal hwnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, ByVal lParam As Integer) As Integer
        End Function

        <DllImport("user32.dll", EntryPoint:="SendMessageA", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfSendMessage(ByVal hwnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, ByVal lParam As Integer) As Integer
        End Function

        <DllImport("user32", EntryPoint:="SendMessageA", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfSendMessageByString(ByVal hwnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, <MarshalAs(UnmanagedType.VBByRefStr)> ByRef lParam As String) As Integer
        End Function

        <DllImport("user32.dll", EntryPoint:="SetParent", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfSetParent(ByVal hWndChild As Integer, ByVal hWndNewParent As Integer) As Integer
        End Function

        <DllImport("user32.dll", EntryPoint:="SetWindowPos", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfSetWindowPos(ByVal hwnd As Integer, ByVal hWndInsertAfter As Integer, ByVal x As Integer, ByVal y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer) As Integer
        End Function

        <DllImport("user32.dll", EntryPoint:="SetWindowTextA", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfSetWindowText(ByVal hwnd As Integer, <MarshalAs(UnmanagedType.VBByRefStr)> ByRef lpString As String) As Integer
        End Function

        <DllImport("user32.dll", EntryPoint:="ShowWindow", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function pfShowWindow(ByVal hwnd As Integer, ByVal nCmdShow As Integer) As Integer
        End Function

        Public Function PostMessage(ByVal hwnd As Integer, ByVal Msg As _WM, ByVal wParam As Integer, ByVal lParam As Integer) As Integer
            Return API.pfPostMessage(hwnd, CInt(Msg), wParam, lParam)
        End Function
        Public Declare Function GetDesktopWindow Lib "user32" () As Integer
        Private Declare Function GetWindow Lib "user32" (ByVal hwnd As Integer, ByVal wCmd As Integer) As Integer
        Private Declare Function GetWindowTextLength Lib "user32" Alias "GetWindowTextLengthA" (ByVal hwnd As Integer) As Integer
        Private Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hwnd As Integer, ByVal lpString As String, ByVal cch As Integer) As Integer
        Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Integer, ByVal nIndex As Integer, ByVal dwNewLong As Integer) As Integer
         Private Declare Function GetWindowThreadProcessId Lib "user32" (ByVal hwnd As Integer, ByRef lpdwProcessId As Integer) As Integer

        Public Sub New(Optional ByVal RegisterAsMainInstance As Boolean = False)
            If RegisterAsMainInstance Then
                API._instance = Me
            End If
        End Sub

        Public Function FindWindow(ByVal ClassName As String, ByVal WindowName As String) As Integer
            Return API.pfFindWindow((ClassName), (WindowName))
        End Function

        Public Function FindWindowEx(ByVal hwndParent As Integer, ByVal hwndChild As Integer, ByVal ClassName As String, ByVal WindowName As String) As Integer
            Return API.pfFindWindowEx(hwndParent, hwndChild, (ClassName), (WindowName))
        End Function

        Public Function GetChildrenOfParent(ByVal lHwndParent As Integer) As ArrayList
            Dim num As Integer
            Dim list2 As New ArrayList
            Dim str2 As String = Nothing
            Dim str As String = Nothing
            num = API.pfFindWindowEx(lHwndParent, num, (str2), (str))
            Do While (num <> 0)
                Try
                    list2.Add(num)
                    str = Nothing
                    str2 = Nothing
                    num = API.pfFindWindowEx(lHwndParent, num, (str), (str2))
                Catch exception1 As Exception
                    ProjectData.SetProjectError(exception1)
                    Dim exception As Exception = exception1
                    ProjectData.ClearProjectError()
                    Return list2
                    ProjectData.ClearProjectError()
                End Try
            Loop
            Return list2
        End Function

        Public Function Getparent(ByVal hwndChild As Integer) As Integer
            Return API.pfGetParent(hwndChild)
        End Function

        Public Function MoveWindow(ByVal hwnd As Integer, ByVal x As Integer, ByVal y As Integer, ByVal width As Integer, ByVal height As Integer, ByVal repaint As Boolean) As Integer
            Dim ret As Integer
            API.pfMoveWindow(hwnd, x, y, width, height, Convert.ToInt32(repaint))
            ret = 340508672
            Return SetWindowLong(hwnd, GWL_STYLE, ret)
        End Function

        Public Function GetNameFromHandle(ByRef hwnd As Integer) As String
            Dim processID As Integer
            Dim threadID As Integer
            Dim i As Integer
            threadID = GetWindowThreadProcessId(hwnd, processID)
            If threadID = 0 Or processID = 0 Then Exit Function
            Dim prclist As Object
            prclist = Process.GetProcesses()
            For i = 0 To UBound(prclist)
                If prclist(i).id = processID Then
                    GetNameFromHandle = prclist(i).mainmodule.filename
                    Exit For
                End If
            Next i
        End Function

        Public Function SearchWindow(ByVal ClassName As String, ByVal WindowName As String, ByVal SearchPriority As ThreadPriority) As Integer
            Dim num As Integer
            Me.moTmpClassName = ClassName
            Me.moTmpWindowName = WindowName
            Dim thread As New Thread(New ThreadStart(AddressOf Me.SearchWindowThread))
            thread.IsBackground = True
            thread.Priority = SearchPriority
            thread.Start()
            Return num
        End Function

        Private Sub SearchWindowThread()
            Dim num As Integer
            Dim dummy As Integer
            Dim strCaption As String
            Dim Pos As Integer


            num = GetDesktopWindow()
            num = GetWindow(num, GW_CHILD)

            Do
                dummy = GetWindowTextLength(num)
                If dummy <> 0 Then
                    strCaption = New String(" ", dummy + 1)
                    dummy = GetWindowText(num, strCaption, dummy + 1)
                    Pos = Microsoft.VisualBasic.InStr(1, strCaption, Me.moTmpWindowName, Microsoft.VisualBasic.CompareMethod.Text)
                    If Pos > 0 Then
                        If GetNameFromHandle(num) = CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_SET_DEPATH Then
                            PPC_HWND = num
                            Exit Do
                        End If
                    End If
                End If
                num = GetWindow(num, GW_HWNDNEXT)
            Loop While num <> 0

            If (Not Me.WindowFoundEvent Is Nothing) Then
                Me.WindowFoundEvent.Invoke(PPC_HWND)
            End If
        End Sub

        Public Function SendMessage(ByVal hwnd As Integer, ByVal Msg As _WM, ByVal wParam As Integer, ByVal lParam As Integer) As Integer
            Return API.pfSendMessage(hwnd, CInt(Msg), wParam, lParam)
        End Function

        Public Function SetParent(ByVal hwndChild As Integer, ByVal hwndNewParent As Integer) As Integer
            Return API.pfSetParent(hwndChild, hwndNewParent)
        End Function

        Public Function SetWindowPos(ByVal hwnd As Integer, ByVal hWndInsertAfter As _HWND, ByVal x As Integer, ByVal y As Integer, ByVal width As Integer, ByVal height As Integer, ByVal wFlags As _SWP) As Integer
            Return API.pfSetWindowPos(hwnd, CInt(hWndInsertAfter), x, y, width, height, CInt(wFlags))
        End Function

        Public Function ShowWindow(ByVal hwnd As Integer, ByVal CmdShow As Integer) As Integer
            Return API.pfShowWindow(hwnd, CmdShow)
        End Function

        Public Shared ReadOnly Property instance() As API
            Get
                If (API._instance Is Nothing) Then
                    API._instance = New API(False)
                End If
                Return API._instance
            End Get
        End Property

        Private Shared _instance As API
        Private moTmpClassName As String
        Private moTmpWindowName As String

        Public Enum _HWND
            HWND_BOTTOM = 1
            HWND_NOTOPMOST = -2
            HWND_TOP = 0
            HWND_TOPMOST = -1
        End Enum

        Public Enum _SWP
            SWP_ASYNCWINDOWPOS = &H4000
            SWP_DEFERERASE = &H2000
            SWP_DRAWFRAME = &H20
            SWP_FRAMECHANGED = &H20
            SWP_HIDEWINDOW = &H80
            SWP_NOACTIVATE = &H10
            SWP_NOCOPYBITS = &H100
            SWP_NOMOVE = 2
            SWP_NOOWNERZORDER = &H200
            SWP_NOREDRAW = 8
            SWP_NOREPOSITION = &H200
            SWP_NOSENDCHANGING = &H400
            SWP_NOSIZE = 1
            SWP_NOZORDER = 4
            SWP_SHOWWINDOW = &H40
        End Enum

        Public Enum _WM
            WM_CLOSE = &H10
            WM_COMMAND = &H111
            WM_LBUTTONDOWN = &H201
            WM_LBUTTONUP = &H202
            WM_MOUSEACTIVATE = &H21
        End Enum
        Const GW_CHILD As Short = 5
        Const GW_HWNDNEXT As Short = 2
        Const GWL_STYLE As Short = (-16)
        Const WS_THICKFRAME As Integer = &H40000
        Const WS_BORDER As Integer = &H800000


        Public Shared PPC_HWND As Integer
        Public Delegate Sub WindowFoundEventHandler(ByVal hwnd As Integer)

        Private Structure PROCESSENTRY32
            Dim dwSize As Integer
            Dim cntUsage As Integer
            Dim th32ProcessID As Integer
            Dim th32DefaultHeapID As Integer
            Dim th32ModuleID As Integer
            Dim cntThreads As Integer
            Dim th32ParentProcessID As Integer
            Dim pcPriClassBase As Integer
            Dim dwflags As Integer
            Dim szexeFile As String
        End Structure

    End Class
End Namespace


