Imports centrafuse.Plugins
Imports CF_Full_Screen_Programm.FSP
Imports Microsoft.VisualBasic.CompilerServices
Imports System
Imports System.Collections
Imports System.Diagnostics
Imports System.Drawing
Imports System.IO
Imports System.Runtime.CompilerServices
Imports System.Threading
Imports System.Web
Imports System.Windows.Forms
Imports System.Xml


Namespace CF_Full_Screen_Programm.FullScreenProgramm


    Public Class Full_Screen_Programm
        Inherits CFPlugin

        ' Methods
        Public Sub New()
            Dim aunit() As String
            Dim Modul As System.Reflection.Module = System.Reflection.Assembly.GetExecutingAssembly().GetModules()(0)
            Dim Path As String = Modul.FullyQualifiedName
            aunit = Split(Path, "\")
            Path = Path.Substring(0, Path.LastIndexOf("\")) & "\"
            ConfigPath = Path & "Seting.xml"
            SkinPath = Path & "Skins\Clean\"
            PluginName = aunit(UBound(aunit) - 1)
#If _Centrafuse = 2 Then
            Me.CF_pluginHasSettings = True
            Me.CF_pluginHasBasicSettings = True
            Me.CF_pluginPauseAudioFlag = False
#ElseIf _Centrafuse = 3 Then
    MyBase.CF_params.hasSettings = True
    MyBase.CF_params.hasBasicSettings = True
#End If
            

        End Sub
        Public Sub Beep()
            CF_systemCommand(CF_Actions.BEEPSOUND)
        End Sub
        Public Overrides Function CF_pluginShowSetup() As DialogResult

            Dim cancel As DialogResult = DialogResult.Cancel
            Try
                Dim setup As New CF_Full_Screen_Programm.FullScreenProgramm.setup
                setup.MainForm = MyBase.MainForm
                setup.setupSection()
                cancel = setup.ShowDialog
                If (cancel = DialogResult.OK) Then
                    Me.loadSettings()
                End If
                setup.Close()
                setup = Nothing
            Catch exception1 As Exception
                CFTools.writeError(exception1.ToString)
            End Try
            Return cancel
        End Function

        Private Sub API_WindowFound(ByVal hwnd As Integer)
            Dim altscan As Integer
            Dim ret As Integer
            Const VK_RETURN = &HD
            Const VK_MENU = &H12
            Const KEYEVENTF_KEYUP = &H2

            If Me.FSP_SEND_APP_ALT_ENTER = 0 Then
                ret = GetWindowLong(hwnd, GWL_STYLE)
                If ret <> 349159424 Then
                    SetForegroundWindow(hwnd)
                    altscan = MapVirtualKey(VK_MENU, 0)
                    keybd_event(VK_MENU, altscan, 0, 0)
                    System.Windows.Forms.Application.DoEvents()
                    keybd_event(VK_RETURN, 0, 0, 0)
                    System.Windows.Forms.Application.DoEvents()
                    keybd_event(VK_MENU, altscan, KEYEVENTF_KEYUP, 0)
                End If
            End If

            Thread.Sleep(&H3E8)
            Me.API.SetWindowPos(hwnd, API._HWND.HWND_NOTOPMOST, (0 - (Me.FSP_SET_WIDTH + 6)), (0 - (Me.FSP_SET_HEIGHT + &H37)), 0, 0, API._SWP.SWP_NOSIZE)
            Me.API.PPC_HWND = hwnd
            Me.FSP_isEmbedded = False
            Me.Full_Screen_Programm_VisibleChanged(Me, New EventArgs)
        End Sub
        Public Sub ScreenKeyboardHide()
            isKeyboard = False
            KeyBoardForm.Hide()
            Me.SetFullScreen(Me.isFullscreen)
            FSP_UPDATEWINDOW()
        End Sub
        Public Sub ScreenKeyboardShow()
            isKeyboard = True
            Try
                ComButton.Timer.Enabled = False
                ComButton.MinMax.Visible = False
                ComButton.Close.Visible = False
                ComButton.Home.Visible = False
                ComButton.Update.Visible = False
                ComButton.Keyboard.Visible = False
                ComButton.TransparencyKey = Color.red

                Me.Left = Me.FSP_SET_FULLSCREEN_X
                Me.Top = Me.FSP_SET_FULLSCREEN_Y
                Me.Height = Me.FSP_SET_FULLSCREEN_HEIGHT
                Me.Width = Me.FSP_SET_FULLSCREEN_WIDTH
                Me.mPanel.Top = 0
                Me.mPanel.Left = 0
                Me.mPanel.Height = Me.FSP_SET_FULLSCREEN_HEIGHT
                Me.mPanel.Width = Me.FSP_SET_FULLSCREEN_WIDTH

                ComButton.Show()
                ComButton.Width = Me.FSP_SET_FULLSCREEN_BUTTON_WIDTH
                ComButton.Height = Me.FSP_SET_FULLSCREEN_BUTTON_HEIGHT

                If Me.FSP_SET_FULLSCREEN_BUTTON_TOP < Me.Top Then
                    Me.FSP_SET_FULLSCREEN_BUTTON_TOP = Me.Top
                ElseIf Me.FSP_SET_FULLSCREEN_BUTTON_TOP + Me.FSP_SET_FULLSCREEN_BUTTON_HEIGHT > Me.Top + Me.Height Then
                    Me.FSP_SET_FULLSCREEN_BUTTON_TOP = Me.Height - Me.FSP_SET_FULLSCREEN_BUTTON_HEIGHT
                End If

                If Me.FSP_SET_FULLSCREEN_BUTTON_LEFT < Me.Left Then
                    Me.FSP_SET_FULLSCREEN_BUTTON_LEFT = Me.Left
                ElseIf Me.FSP_SET_FULLSCREEN_BUTTON_LEFT + Me.FSP_SET_FULLSCREEN_BUTTON_WIDTH > Me.Left + Me.Width Then
                    Me.FSP_SET_FULLSCREEN_BUTTON_LEFT = Me.Width - Me.FSP_SET_FULLSCREEN_BUTTON_WIDTH
                End If


                ComButton.Top = Me.FSP_SET_FULLSCREEN_BUTTON_TOP
                ComButton.Left = Me.FSP_SET_FULLSCREEN_BUTTON_LEFT

                ComButton.Opacity = Me.FSP_SET_FULLSCREEN_BUTTON_OPACITY / 100
                ComButton.MinMax.Visible = False
                ComButton.Close.Visible = False
                ComButton.Home.Visible = False
                ComButton.Update.Visible = False
                ComButton.Keyboard.Visible = False
                ComButton.TransparencyKey = Color.red
                ComButton.Owner = Me
                KeyBoardForm.Width = Me.FSP_SET_FULLSCREEN_WIDTH
                KeyBoardForm.Show()
                KeyBoardForm.Owner = Me

                KeyBoardForm.Top = Me.Height - KeyBoardForm.Height

                Me.FSP_SET_CURENT_APP_TOP = Me.FSP_SET_FULLSCREEN_APP_TOP
                Me.FSP_SET_CURENT_APP_BOTTOM = Me.FSP_SET_FULLSCREEN_APP_BOTTOM - KeyBoardForm.Height
                Me.FSP_SET_CURENT_APP_LEFT = Me.FSP_SET_FULLSCREEN_APP_LEFT
                Me.FSP_SET_CURENT_APP_RIGHT = Me.FSP_SET_FULLSCREEN_APP_RIGHT

                FSP_UPDATEWINDOW()
            Catch exception1 As Exception

            End Try
        End Sub

        Public Sub Screen()
            Try
                If isKeyboard = True Then
                    KeyBoardForm.Hide()
                    isKeyboard = False
                End If
                Me.isFullscreen = Not Me.isFullscreen
                Me.SetFullScreen(Me.isFullscreen)
                ComButton.Timer.Enabled = False
                ComButton.MinMax.Visible = False
                ComButton.Close.Visible = False
                ComButton.Home.Visible = False
                ComButton.Update.Visible = False
                ComButton.Keyboard.Visible = False
                ComButton.TransparencyKey = Color.red
            Catch exception1 As Exception

            End Try
        End Sub
        Private Sub btnScreen_Click(ByVal sender As Object, ByVal e As MouseEventArgs)
            Screen()
        End Sub


        Public Overrides Sub CF_pluginClose()
            Hook.UninstallHook(HookTypes.KeyboardLL)

            Me.FSP_SHUTDOWN()
        End Sub



        Public Overrides Sub CF_pluginInit()
            AddHandler MyBase.VisibleChanged, New EventHandler(AddressOf Me.Full_Screen_Programm_VisibleChanged)
            Me.isFullscreen = False
            Me.isVisible = False
            Me.isPanelSet = False


#If _Centrafuse = 2 Then

#ElseIf _Centrafuse = 3 Then
            MyBase.CF_params.pauseAudio = False
            MyBase.CF_setPlayPauseButton(True, False)
#End If


            Full_Screen_Programm._instance = Me
            Try
                Hook.InstallHookKeyboard(HookTypes.KeyboardLL)
                Hook.InitHookMouse(HookTypes.MouseLL)
            Catch ex As Exception

            End Try
            Try
                Me.API = New API(True)
                Me.mPanel = New Panel
                Me.Controls.Add(Me.mPanel)
                Me.loadSettings()
                Me.ResumeLayout(False)
#If _Centrafuse = 2 Then

#ElseIf _Centrafuse = 3 Then
            CF3_initPlugin(PluginName, True)
#End If
                If (StringType.StrCmp(MyBase.pluginConfig.readPluginField("/APPCONFIG/RUNONSTARTUP").ToUpper, "TRUE", False) = 0) Then
                    Me.FSP_STARTUP()
                    Me.Refresh()
                End If

            Catch exception1 As Exception

            End Try
        End Sub
        Public Overrides Sub CF_pluginPause()

        End Sub
        Public Overrides Sub CF_pluginResetVis()

        End Sub
        Public Sub FSP_Show()
            CF_systemCommand(CF_Actions.PLUGIN, PluginName)
        End Sub
        Public Overrides Sub CF_pluginShow()
            Me.Visible = True
        End Sub




        Public Sub loadSettings()
            Dim KeyScanStr() As String
            Dim ButtonWidth As Integer
            Dim ButtonHeight As Integer
            Dim Zazor As Integer
            Dim FontName As String
            Dim FontSize As Single
            Dim FontStyle As Integer

            Me.CF_loadConfig(ConfigPath)
            Me.CF_pluginDisplayName = MyBase.pluginConfig.readPluginField("/APPCONFIG/DISPLAYNAME")
            Try
                Me.isFullscreen = Boolean.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREENLAUNCH"))
            Catch exception1 As Exception

            End Try

            Me.isPanelSet = False
            Try
                Me.FSP_SET_DEPATH = MyBase.pluginConfig.readPluginField("/APPCONFIG/DEPATH").Trim
                Me.FSP_WINDOWNAME = MyBase.pluginConfig.readPluginField("/APPCONFIG/SEARCHCAPTION").Trim
                Me.FSP_sArguments = MyBase.pluginConfig.readPluginField("/APPCONFIG/ARGUMENTS").Trim

                Me.FSP_THREAD_SLEEP = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/TIMEBEFOREWINDOWSEARCH"))
                Me.FSP_SET_SCREEN_WIDTH = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/WIDTH"))
                Me.FSP_SET_SCREEN_HEIGHT = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/HEIGHT"))
                Me.FSP_SET_SCREEN_X = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/X"))
                Me.FSP_SET_SCREEN_Y = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/Y"))

                Me.FSP_SET_SCREEN_BUTTON_TOP = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/BUTTONSTOP"))
                Me.FSP_SET_SCREEN_BUTTON_LEFT = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/BUTTONSLEFT"))

                Me.FSP_SET_SCREEN_BUTTON_WIDTH = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/BUTTONSWIDTH"))
                Me.FSP_SET_SCREEN_BUTTON_HEIGHT = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/BUTTONSHEIGHT"))
                Me.FSP_SET_SCREEN_BUTTON_OPACITY = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/BUTTONSOPACITY"))
                Me.FSP_SET_SCREEN_BUTTON_SHOW_OPACITY = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/BUTTONSSHOWOPACITY"))
                Me.FSP_SET_SCREEN_BUTTON_SHOW_TIME = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/BUTTONSSHOWTIME")) * 1000

                Me.FSP_SET_SCREEN_APP_TOP = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/APPTOP"))
                Me.FSP_SET_SCREEN_APP_BOTTOM = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/APPBOTTOM"))
                Me.FSP_SET_SCREEN_APP_LEFT = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/APPLEFT"))
                Me.FSP_SET_SCREEN_APP_RIGHT = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/SCREEN/APPRIGHT"))

                Me.FSP_SET_FULLSCREEN_WIDTH = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/WIDTH"))
                Me.FSP_SET_FULLSCREEN_HEIGHT = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/HEIGHT"))
                Me.FSP_SET_FULLSCREEN_X = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/X"))
                Me.FSP_SET_FULLSCREEN_Y = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/Y"))
                Me.FSP_SET_FULLSCREEN_BUTTON_TOP = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/BUTTONSTOP"))
                Me.FSP_SET_FULLSCREEN_BUTTON_LEFT = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/BUTTONSLEFT"))

                Me.FSP_SET_FULLSCREEN_BUTTON_WIDTH = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/BUTTONSWIDTH"))
                Me.FSP_SET_FULLSCREEN_BUTTON_HEIGHT = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/BUTTONSHEIGHT"))
                Me.FSP_SET_FULLSCREEN_BUTTON_OPACITY = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/BUTTONSOPACITY"))
                Me.FSP_SET_FULLSCREEN_BUTTON_SHOW_OPACITY = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/BUTTONSSHOWOPACITY"))
                Me.FSP_SET_FULLSCREEN_BUTTON_SHOW_TIME = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/BUTTONSSHOWTIME")) * 1000

                Me.FSP_SET_FULLSCREEN_APP_TOP = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/APPTOP"))
                Me.FSP_SET_FULLSCREEN_APP_BOTTOM = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/APPBOTTOM"))
                Me.FSP_SET_FULLSCREEN_APP_LEFT = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/APPLEFT"))
                Me.FSP_SET_FULLSCREEN_APP_RIGHT = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/FULLSCREEN/APPRIGHT"))

                Me.FSP_HOTKEY_SHOW = MyBase.pluginConfig.readPluginField("/APPCONFIG/HOTKEY/SHOW").Trim
                Me.FSP_HOTKEY_HIDE = MyBase.pluginConfig.readPluginField("/APPCONFIG/HOTKEY/HIDE").Trim
                Me.FSP_HOTKEY_FULLSCREEN = MyBase.pluginConfig.readPluginField("/APPCONFIG/HOTKEY/SCREENFULLSCREEN").Trim
                Me.FSP_HOTKEY_APPCLOSE = MyBase.pluginConfig.readPluginField("/APPCONFIG/HOTKEY/APPCLOSE").Trim
                Me.FSP_HOTKEY_FITWINDOW = MyBase.pluginConfig.readPluginField("/APPCONFIG/HOTKEY/FITWINDOW").Trim

                Me.FSP_REFRESHAPP_BUTTON_PRESENT = StringType.StrCmp(MyBase.pluginConfig.readPluginField("/APPCONFIG/BUTTON/REFRESHAPPWINDOW").ToUpper, "TRUE", True)
                Me.FSP_KEYBOARD_BUTTON_PRESENT = StringType.StrCmp(MyBase.pluginConfig.readPluginField("/APPCONFIG/BUTTON/KEYBOARD").ToUpper, "TRUE", True)
                Me.FSP_SEND_APP_ALT_ENTER = StringType.StrCmp(MyBase.pluginConfig.readPluginField("/APPCONFIG/ALTENTER").ToUpper, "TRUE", True)

                ButtonWidth = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/KEYBOARD/BUTTONSWIDTH"))
                ButtonHeight = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/KEYBOARD/BUTTONSHEIGHT"))
                Zazor = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/KEYBOARD/GAPKEYS"))

                FontName = MyBase.pluginConfig.readPluginField("/APPCONFIG/KEYBOARD/FONTNAME").Trim
                FontSize = Single.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/KEYBOARD/FONTSIZE"))
                FontStyle = Integer.Parse(MyBase.pluginConfig.readPluginField("/APPCONFIG/KEYBOARD/FONTSTYLE"))

                If Not Me.isPanelSet Then
                    Me.FSP_SET_WIDTH = Functions.MakeEvenNumber(CDbl(Me.mPanel.Width))
                    Me.FSP_SET_HEIGHT = Functions.MakeEvenNumber(CDbl(Me.mPanel.Height))
                End If


                KeyScanStr = Split(Me.FSP_HOTKEY_SHOW, "+")

                If KeyScanStr(0) <> "" Then
                    Hook.HotKeyShow.Key = LoadHotKey(KeyScanStr)
                    Hook.HotKeyShow.Enable = True
                Else

                    Hook.HotKeyShow.Enable = False
                End If

                KeyScanStr = Split(Me.FSP_HOTKEY_HIDE, "+")
                If KeyScanStr(0) <> "" Then
                    Hook.HotKeyHide.Key = LoadHotKey(KeyScanStr)
                    Hook.HotKeyHide.Enable = True
                Else
                    Hook.HotKeyHide.Enable = False
                End If


                KeyScanStr = Split(Me.FSP_HOTKEY_FULLSCREEN, "+")
                If KeyScanStr(0) <> "" Then
                    Hook.HotKeyFullScreen.Key = LoadHotKey(KeyScanStr)
                    Hook.HotKeyFullScreen.Enable = True
                Else
                    Hook.HotKeyFullScreen.Enable = False
                End If


                KeyScanStr = Split(Me.FSP_HOTKEY_APPCLOSE, "+")
                If KeyScanStr(0) <> "" Then
                    Hook.HotKeyAppClose.Key = LoadHotKey(KeyScanStr)
                    Hook.HotKeyAppClose.Enable = True
                Else
                    Hook.HotKeyAppClose.Enable = False
                End If

                KeyScanStr = Split(Me.FSP_HOTKEY_FITWINDOW, "+")
                If KeyScanStr(0) <> "" Then
                    Hook.HotKeyFitWindow.Key = LoadHotKey(KeyScanStr)
                    Hook.HotKeyFitWindow.Enable = True
                Else
                    Hook.HotKeyFitWindow.Enable = False
                End If

                ComButton.CloseImage = Image.FromFile(SkinPath & "BtnClose_off.png")
                ComButton.UpdateImage = Image.FromFile(SkinPath & "BtnUpdate_off.png")
                ComButton.HomeImage = Image.FromFile(SkinPath & "BtnHome_off.png")
                ComButton.MinMax_Max = Image.FromFile(SkinPath & "BtnMax_off.png")
                ComButton.MinMax_Min = Image.FromFile(SkinPath & "BtnMin_off.png")
                ComButton.MoveImage = Image.FromFile(SkinPath & "BtnMove_down.png")
                ComButton.KeyboardImage = Image.FromFile(SkinPath & "BtnKey_off.png")


                KeyBoardForm = New KeyboardFrm
                KeyBoardForm.KeyUpImage = Image.FromFile(SkinPath & "ButtonKey_Up.png")
                KeyBoardForm.KeyDownImage = Image.FromFile(SkinPath & "ButtonKey_Down.png")
                KeyBoardForm.KeyFonImage = Image.FromFile(SkinPath & "Key_Fon.png")
                KeyBoardForm.ButtonWidth = ButtonWidth
                KeyBoardForm.ButtonHeight = ButtonHeight
                KeyBoardForm.Zazor = Zazor
                KeyBoardForm.Font = New System.Drawing.Font(FontName, FontSize, FontStyle, System.Drawing.GraphicsUnit.Point, CType(204, Byte))
             
            Catch exception3 As Exception
                ProjectData.SetProjectError(exception3)
                Dim exception2 As Exception = exception3
                CFTools.writeError(exception2.Message, exception2.StackTrace)
                ProjectData.ClearProjectError()
            End Try

        End Sub

        Private Sub mPanel_SizeChanged(ByVal sender As Object, ByVal e As EventArgs)
            Me.FSP_UPDATEWINDOW()
        End Sub

        Private Sub FSP_LAUNCH()
            Me.procDE = New Process
            Me.procDE.StartInfo.FileName = Me.FSP_SET_DEPATH
            Me.procDE.StartInfo.WorkingDirectory = Me.FSP_SET_DEPATH.Substring(0, Me.FSP_SET_DEPATH.LastIndexOf("\"))
            Me.procDE.StartInfo.Arguments = Me.FSP_sArguments
            Me.procDE.EnableRaisingEvents = True
            Me.procDE.Start()

            Thread.Sleep(CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_THREAD_SLEEP)

            Me.API.SearchWindow(Nothing, Me.FSP_WINDOWNAME, ThreadPriority.BelowNormal)
        End Sub

        Public Sub FSP_SHUTDOWN()
            Me.FSP_canExit = True
            Dim process As Process
            For Each process In process.GetProcessesByName(Functions.GetFilenameNoExt(Me.FSP_SET_DEPATH))
                Try
                    process.Kill()
                Catch exception1 As Exception

                End Try
            Next
            Me.Visible = False

            ComButton.Hide()
            KeyBoardForm.Hide()
            isKeyboard = False
            CF_systemCommand(CF_Actions.MAINMENU)
        End Sub
        Public Sub FSP_Hide()

            Me.Visible = False
            KeyBoardForm.Hide()
            isKeyboard = False
            CF_systemCommand(CF_Actions.MAINMENU)
        End Sub

        Private Sub FSP_SHUTDOWNCHECKTHREAD()
            Dim num As Integer = 0
            Do While (((Me.FSP_HWND2 = Me.API.PPC_HWND) And (num < 6)) And (Not Me.procDE Is Nothing))
                Thread.Sleep(&H1388)
                Me.API.PostMessage(Me.API.PPC_HWND, API._WM.WM_COMMAND, &H9C41, 0)
                If ((Not Me.procDE Is Nothing) AndAlso Not Me.procDE.Responding) Then
                    num = 6
                End If
                num += 1
            Loop
            If (num >= 6) Then
                Dim process As Process
                For Each process In process.GetProcessesByName(Functions.GetFilenameNoExt(Me.FSP_SET_DEPATH))
                    Try
                        process.Kill()
                    Catch exception1 As Exception
                        ProjectData.SetProjectError(exception1)
                        Dim exception As Exception = exception1
                        ProjectData.ClearProjectError()
                    End Try
                Next
            End If
        End Sub

        Private Sub FSP_STARTUP()
            Me.FSP_isEmbedded = False
            Me.FSP_canExit = False
            Dim flag As Boolean = False
            If Not File.Exists(Me.FSP_SET_DEPATH) Then
                If ((Me.isVisible AndAlso (Me.CF_systemDisplayDialog(CF_Dialogs.OkBox, "Path not found") = DialogResult.OK))) Then
                    Me.Visible = False
                    Exit Sub
                End If
            Else
                If (Me.API.FindWindow(Nothing, Me.FSP_WINDOWNAME) > 0) Then
                    flag = True
                End If
                Dim processesByName As Process() = Process.GetProcessesByName(Functions.GetFilenameNoExt(Me.FSP_SET_DEPATH))
                If ((processesByName.Length > 0) And Not flag) Then
                    Dim process As Process
                    For Each process In processesByName
                        Try
                            process.Kill()
                        Catch exception1 As Exception

                        End Try
                    Next
                    Thread.Sleep(&H3E8)
                End If
                Me.FSP_doLaunch = True
                Me.FSP_LAUNCH()
            End If
        End Sub

        Public Sub FSP_UPDATEWINDOW()
            If (Me.API.PPC_HWND > 0) Then
                Me.API.MoveWindow(Me.API.PPC_HWND, Me.FSP_SET_CURENT_APP_LEFT, Me.FSP_SET_CURENT_APP_TOP, Me.Width + Me.FSP_SET_CURENT_APP_RIGHT, Me.Height + Me.FSP_SET_CURENT_APP_BOTTOM, True)
                Me.Refresh()
            End If
        End Sub


        Private Sub Full_Screen_Programm_VisibleChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.VisibleChanged
            Me.isVisible = Me.Visible
            If Me.isVisible Then
                ComButton.Show()
                Me.SetFullScreen(Me.isFullscreen)
                FSP_UPDATEWINDOW()
                Me.Refresh()
                If Not Me.FspIsRunning Then
                    Me.FSP_STARTUP()
                ElseIf Not Me.FSP_isEmbedded Then
                    Me.API.SetParent(Me.API.PPC_HWND, Me.mPanel.Handle.ToInt32)
                    Me.FSP_UPDATEWINDOW()
                    Me.FSP_isEmbedded = True
                End If
            Else
                ComButton.Hide()
            End If
        End Sub

        Private Sub procDE_Disposed(ByVal sender As Object, ByVal e As EventArgs)
            Me.API.PPC_HWND = 0
            Me.procDE = Nothing
            Me.FSP_isEmbedded = False
            Me.FSP_SHUTDOWN()
        End Sub

        Public Sub UpdateWindow()
            Me.API.SearchWindow(Nothing, Me.FSP_WINDOWNAME, ThreadPriority.BelowNormal)
        End Sub

        Public Sub SetFullScreen(ByVal Fullscreen As Boolean)
            Try
                Me.CF_clearControls()

                If Fullscreen = True Or isKeyboard = True Then
                    Me.FSP_SET_CURENT_APP_TOP = Me.FSP_SET_FULLSCREEN_APP_TOP
                    Me.FSP_SET_CURENT_APP_BOTTOM = Me.FSP_SET_FULLSCREEN_APP_BOTTOM
                    Me.FSP_SET_CURENT_APP_LEFT = Me.FSP_SET_FULLSCREEN_APP_LEFT
                    Me.FSP_SET_CURENT_APP_RIGHT = Me.FSP_SET_FULLSCREEN_APP_RIGHT

                    Me.Left = Me.FSP_SET_FULLSCREEN_X
                    Me.Top = Me.FSP_SET_FULLSCREEN_Y
                    Me.Height = Me.FSP_SET_FULLSCREEN_HEIGHT
                    Me.Width = Me.FSP_SET_FULLSCREEN_WIDTH
                    Me.mPanel.Top = 0
                    Me.mPanel.Left = 0
                    Me.mPanel.Height = Me.FSP_SET_FULLSCREEN_HEIGHT
                    Me.mPanel.Width = Me.FSP_SET_FULLSCREEN_WIDTH

                    ComButton.Show()
                    ComButton.Width = Me.FSP_SET_FULLSCREEN_BUTTON_WIDTH
                    ComButton.Height = Me.FSP_SET_FULLSCREEN_BUTTON_HEIGHT

                    If Me.FSP_SET_FULLSCREEN_BUTTON_TOP < Me.Top Then
                        Me.FSP_SET_FULLSCREEN_BUTTON_TOP = Me.Top
                    ElseIf Me.FSP_SET_FULLSCREEN_BUTTON_TOP + Me.FSP_SET_FULLSCREEN_BUTTON_HEIGHT > Me.Top + Me.Height Then
                        Me.FSP_SET_FULLSCREEN_BUTTON_TOP = Me.Height - Me.FSP_SET_FULLSCREEN_BUTTON_HEIGHT
                    End If

                    If Me.FSP_SET_FULLSCREEN_BUTTON_LEFT < Me.Left Then
                        Me.FSP_SET_FULLSCREEN_BUTTON_LEFT = Me.Left
                    ElseIf Me.FSP_SET_FULLSCREEN_BUTTON_LEFT + Me.FSP_SET_FULLSCREEN_BUTTON_WIDTH > Me.Left + Me.Width Then
                        Me.FSP_SET_FULLSCREEN_BUTTON_LEFT = Me.Width - Me.FSP_SET_FULLSCREEN_BUTTON_WIDTH
                    End If


                    ComButton.Top = Me.FSP_SET_FULLSCREEN_BUTTON_TOP
                    ComButton.Left = Me.FSP_SET_FULLSCREEN_BUTTON_LEFT

                    ComButton.Opacity = Me.FSP_SET_FULLSCREEN_BUTTON_OPACITY / 100
                    ComButton.MinMax.Visible = False
                    ComButton.Close.Visible = False
                    ComButton.Home.Visible = False
                    ComButton.Update.Visible = False
                    ComButton.Keyboard.Visible = False
                    ComButton.TransparencyKey = Color.Red
                    ComButton.Owner = Me



                Else

                    Me.FSP_SET_CURENT_APP_TOP = Me.FSP_SET_SCREEN_APP_TOP
                    Me.FSP_SET_CURENT_APP_BOTTOM = Me.FSP_SET_SCREEN_APP_BOTTOM
                    Me.FSP_SET_CURENT_APP_LEFT = Me.FSP_SET_SCREEN_APP_LEFT
                    Me.FSP_SET_CURENT_APP_RIGHT = Me.FSP_SET_SCREEN_APP_RIGHT

                    Me.Left = Me.FSP_SET_SCREEN_X
                    Me.Top = Me.FSP_SET_SCREEN_Y
                    Me.Height = Me.FSP_SET_SCREEN_HEIGHT
                    Me.Width = Me.FSP_SET_SCREEN_WIDTH

                    Me.mPanel.Top = 0
                    Me.mPanel.Left = 0
                    Me.mPanel.Height = Me.FSP_SET_SCREEN_HEIGHT
                    Me.mPanel.Width = Me.FSP_SET_SCREEN_WIDTH

                    If Me.FSP_SET_SCREEN_BUTTON_TOP < Me.Top Then
                        Me.FSP_SET_SCREEN_BUTTON_TOP = Me.Top
                    ElseIf Me.FSP_SET_SCREEN_BUTTON_TOP + Me.FSP_SET_SCREEN_BUTTON_HEIGHT > Me.Top + Me.Height Then
                        Me.FSP_SET_SCREEN_BUTTON_TOP = Me.Height - Me.FSP_SET_SCREEN_BUTTON_HEIGHT
                    End If

                    If Me.FSP_SET_SCREEN_BUTTON_LEFT < Me.Left Then
                        Me.FSP_SET_SCREEN_BUTTON_LEFT = Me.Left
                    ElseIf Me.FSP_SET_SCREEN_BUTTON_LEFT + Me.FSP_SET_SCREEN_BUTTON_WIDTH > Me.Left + Me.Width Then
                        Me.FSP_SET_SCREEN_BUTTON_LEFT = Me.Width - Me.FSP_SET_SCREEN_BUTTON_WIDTH
                    End If

                    ComButton.Show()
                    ComButton.Width = Me.FSP_SET_SCREEN_BUTTON_WIDTH
                    ComButton.Height = Me.FSP_SET_SCREEN_BUTTON_HEIGHT
                    ComButton.Top = Me.FSP_SET_SCREEN_BUTTON_TOP
                    ComButton.Left = Me.FSP_SET_SCREEN_BUTTON_LEFT
                    ComButton.Opacity = Me.FSP_SET_SCREEN_BUTTON_OPACITY / 100
                    ComButton.MinMax.Visible = False
                    ComButton.Close.Visible = False
                    ComButton.Home.Visible = False
                    ComButton.Update.Visible = False
                    ComButton.Keyboard.Visible = False
                    ComButton.TransparencyKey = Color.Red
                    ComButton.Owner = Me


                End If
                Me.Invalidate()
            Catch exception1 As Exception

            End Try
        End Sub



        Overridable Property API() As API
            Get
                Return Me._API
            End Get
            Set(ByVal WithEventsValue As API)
                If (Not Me._API Is Nothing) Then
                    RemoveHandler Me._API.WindowFound, New API.WindowFoundEventHandler(AddressOf Me.API_WindowFound)
                End If
                Me._API = WithEventsValue
                If (Not Me._API Is Nothing) Then
                    AddHandler Me._API.WindowFound, New API.WindowFoundEventHandler(AddressOf Me.API_WindowFound)
                End If
            End Set
        End Property

        Public Shared ReadOnly Property GetInstance() As Full_Screen_Programm
            Get
                Return Full_Screen_Programm._instance
            End Get
        End Property

        Overridable Property mPanel() As Panel
            Get
                Return Me._mPanel
            End Get
            Set(ByVal WithEventsValue As Panel)
                If (Not Me._mPanel Is Nothing) Then
                    RemoveHandler Me._mPanel.SizeChanged, New EventHandler(AddressOf Me.mPanel_SizeChanged)
                End If
                Me._mPanel = WithEventsValue
                If (Not Me._mPanel Is Nothing) Then
                    AddHandler Me._mPanel.SizeChanged, New EventHandler(AddressOf Me.mPanel_SizeChanged)
                End If
            End Set
        End Property

        Public ReadOnly Property FspIsRunning() As Boolean
            Get
                Return (Not Me.procDE Is Nothing)
            End Get
        End Property

        Overridable Property procDE() As Process
            Get
                Return Me._procDE
            End Get
            Set(ByVal WithEventsValue As Process)
                If (Not Me._procDE Is Nothing) Then
                    RemoveHandler Me._procDE.Exited, New EventHandler(AddressOf Me.procDE_Disposed)
                    RemoveHandler Me._procDE.Disposed, New EventHandler(AddressOf Me.procDE_Disposed)
                End If
                Me._procDE = WithEventsValue
                If (Not Me._procDE Is Nothing) Then
                    AddHandler Me._procDE.Exited, New EventHandler(AddressOf Me.procDE_Disposed)
                    AddHandler Me._procDE.Disposed, New EventHandler(AddressOf Me.procDE_Disposed)
                End If
            End Set
        End Property


        <AccessedThroughProperty("API")> _
        Private _API As API
        Private Shared _instance As Full_Screen_Programm
        <AccessedThroughProperty("mPanel")> _
        Private _mPanel As Panel
        <AccessedThroughProperty("procDE")> _
        Private _procDE As Process
        Public isFullscreen As Boolean
        Public isKeyboard As Boolean
        Private isPanelSet As Boolean
        Private isVisible As Boolean
        Private FSP_canExit As Boolean
        Private FSP_doLaunch As Boolean
        Private FSP_HWND2 As Integer
        Private FSP_isEmbedded As Boolean
        Private FSP_sArguments As String

        Public FSP_SET_DEPATH As String
        Private FSP_SET_HEIGHT As Integer
        Private FSP_SET_WIDTH As Integer
        Private FSP_WINDOWNAME As String
        Public FSP_THREAD_SLEEP As Integer

        Private FSP_SET_SCREEN_WIDTH As Integer
        Private FSP_SET_SCREEN_HEIGHT As Integer
        Private FSP_SET_SCREEN_X As Integer
        Private FSP_SET_SCREEN_Y As Integer

        Public FSP_SET_SCREEN_BUTTON_TOP As Integer
        Public FSP_SET_SCREEN_BUTTON_LEFT As Integer
        Public FSP_SET_SCREEN_BUTTON_WIDTH As Integer
        Public FSP_SET_SCREEN_BUTTON_HEIGHT As Integer
        Public FSP_SET_SCREEN_BUTTON_OPACITY As Integer
        Public FSP_SET_SCREEN_BUTTON_SHOW_OPACITY As Integer
        Public FSP_SET_SCREEN_BUTTON_SHOW_TIME As Integer

        Private FSP_SET_SCREEN_APP_TOP As Integer
        Private FSP_SET_SCREEN_APP_BOTTOM As Integer
        Private FSP_SET_SCREEN_APP_LEFT As Integer
        Private FSP_SET_SCREEN_APP_RIGHT As Integer

        Private FSP_SET_FULLSCREEN_WIDTH As Integer
        Private FSP_SET_FULLSCREEN_HEIGHT As Integer
        Private FSP_SET_FULLSCREEN_X As Integer
        Private FSP_SET_FULLSCREEN_Y As Integer

        Public FSP_SET_FULLSCREEN_BUTTON_TOP As Integer
        Public FSP_SET_FULLSCREEN_BUTTON_LEFT As Integer
        Public FSP_SET_FULLSCREEN_BUTTON_WIDTH As Integer
        Public FSP_SET_FULLSCREEN_BUTTON_HEIGHT As Integer
        Public FSP_SET_FULLSCREEN_BUTTON_OPACITY As Integer
        Public FSP_SET_FULLSCREEN_BUTTON_SHOW_OPACITY As Integer
        Public FSP_SET_FULLSCREEN_BUTTON_SHOW_TIME As Integer
        Public FSP_REFRESHAPP_BUTTON_PRESENT As Integer
        Public FSP_KEYBOARD_BUTTON_PRESENT As Integer
        Private FSP_SEND_APP_ALT_ENTER As Integer

        Private FSP_SET_FULLSCREEN_APP_TOP As Integer
        Private FSP_SET_FULLSCREEN_APP_BOTTOM As Integer
        Private FSP_SET_FULLSCREEN_APP_LEFT As Integer
        Private FSP_SET_FULLSCREEN_APP_RIGHT As Integer

        Private FSP_SET_CURENT_APP_TOP As Integer
        Private FSP_SET_CURENT_APP_BOTTOM As Integer
        Private FSP_SET_CURENT_APP_LEFT As Integer
        Private FSP_SET_CURENT_APP_RIGHT As Integer

        Private FSP_HOTKEY_SHOW As String
        Private FSP_HOTKEY_HIDE As String
        Private FSP_HOTKEY_FULLSCREEN As String
        Private FSP_HOTKEY_APPCLOSE As String
        Private FSP_HOTKEY_FITWINDOW As String
        Public ConfigPath As String = "plugins/FSProgramm2/config.xml"
        Public PluginName As String = "FSProgramm2"
        Dim SkinPath As String

        Dim i As Integer
        Const GWL_STYLE As Short = (-16)

        Private Declare Function MapVirtualKey Lib "user32" Alias "MapVirtualKeyA" (ByVal wCode As Integer, ByVal wMapType As Integer) As Integer
        Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" (ByVal hwnd As Integer, ByVal nIndex As Integer) As Integer
        Private Declare Function SetForegroundWindow Lib "user32" (ByVal hwnd As Integer) As Integer
        Private Declare Sub keybd_event Lib "user32" (ByVal bVk As Byte, ByVal bScan As Byte, ByVal dwFlags As Long, ByVal dwExtraInfo As Long)


        Private Function LoadHotKey(ByVal KeyScanStr As Object) As Object
            Dim i As Short
            Dim TempKey(UBound(KeyScanStr)) As Integer
            For i = 0 To UBound(KeyScanStr)
                Try
                    TempKey(i) = CInt(KeyScanStr(i))
                Catch ex As Exception

                End Try
            Next i
            LoadHotKey = TempKey
        End Function
    End Class
End Namespace
