﻿Imports System.Runtime.CompilerServices
Imports System.Runtime.InteropServices
Namespace CF_Full_Screen_Programm
   
    Module Hook
        Public Declare Sub mouse_event Lib "user32" (ByVal dwFlags As Integer, ByVal dx As Integer, ByVal dy As Integer, ByVal cButtons As Integer, ByVal dwExtraInfo As Integer)
        Public Const MOUSEEVENT_ABSOLUTE = &H8000
        Public Const MOUSEEVENT_LEFTUP = &H4

        'Dim intLLKey As Integer
        Public Structure HotKeyS
            Dim Key() As Integer
            Dim CurentKey As Short
            Dim Enable As Boolean
        End Structure
        Public HotKeyShow As HotKeyS
        Public HotKeyHide As HotKeyS
        Public HotKeyFullScreen As HotKeyS
        Public HotKeyAppClose As HotKeyS
        Public HotKeyFitWindow As HotKeyS
        Public OldKeyCode As Integer
        Public SetingHotKey As Boolean
        Public RecHotKey As Boolean
        Public HotKeyCom As String
        Public SetHotKey As Boolean
        Public HotKeyComStr As String
        Private HotKeyDown As Boolean
        Private _isHooked As Boolean = False
        Private _processHandlerKeyboard As HookProcessedHandler = Nothing
        Private _processHandlerMouse As HookProcessedHandler = Nothing
        Private _type As HookTypes = HookTypes.None
        Public MOUSEEVENT_LEFTUP_BOOLEAN As Boolean
        Public MOUSEEVENT_LEFTUP_IGNORE As Boolean
        Public DownMouseX As Integer
        Public DownMouseY As Integer
        Public ButtonWidth As Integer
        Public ButtonHeight As Integer
  


        Private Enum FilterMessageResults
            ' Fields
            Failed = -2
            NotImplemented = -3
            Success = 1
        End Enum

        Delegate Sub HookProcessedHandler(ByVal code As Integer, ByVal wparam As UIntPtr, ByVal lparam As IntPtr)
        <DllImport("HookFSP.dll", CallingConvention:=CallingConvention.StdCall, CharSet:=CharSet.Unicode, SetLastError:=True, ExactSpelling:=True)> _
        Private Function InitializeHook(ByVal hookType As HookTypes, ByVal threadID As Integer) As Boolean
        End Function

        <DllImport("HookFSP.dll", EntryPoint:="GetKeyboardReading", CallingConvention:=CallingConvention.StdCall, CharSet:=CharSet.Unicode, SetLastError:=True, ExactSpelling:=True)> _
        Private Function IntenralGetKeyboardReading(ByVal wparam As UIntPtr, ByVal lparam As IntPtr, ByRef vkCode As Integer) As Boolean
        End Function

        <DllImport("HookFSP.dll", CallingConvention:=CallingConvention.StdCall, CharSet:=CharSet.Unicode, SetLastError:=True, ExactSpelling:=True)> _
         Private Function SetUserHookCallback(ByVal hookCallback As HookProcessedHandler, ByVal hookType As HookTypes) As SetCallBackResults
        End Function

        <DllImport("HookFSP.dll", CallingConvention:=CallingConvention.StdCall, CharSet:=CharSet.Unicode, SetLastError:=True, ExactSpelling:=True)> _
        Private Sub UninitializeHook(ByVal hookType As HookTypes)
        End Sub

        <DllImport("HookFSP.dll", EntryPoint:="GetMousePosition", CallingConvention:=CallingConvention.StdCall, CharSet:=CharSet.Unicode, SetLastError:=True, ExactSpelling:=True)> _
        Private Function InternalGetMousePosition(ByVal wparam As UIntPtr, ByVal lparam As IntPtr, ByRef x As Integer, ByRef y As Integer) As Boolean
        End Function

        Private Enum SetCallBackResults
            AlreadySet = -2
            ArgumentError = -4
            NotImplemented = -3
            Success = 1
        End Enum
        Public Enum HookTypes
            Hardware = 8
            Keyboard = 2
            KeyboardLL = 13
            Mouse = 7
            MouseLL = 14
            None = -100
            Shell = 10
        End Enum


        Public Function CharFromKeyCode(ByRef k As Integer) As String
            Dim s As String
            Select Case k
                Case System.Windows.Forms.Keys.Back : s = "[BackSpace]"
                Case System.Windows.Forms.Keys.Tab : s = "[Tab]"
                Case System.Windows.Forms.Keys.Clear : s = "[Clear]"
                Case System.Windows.Forms.Keys.Return : s = "[Enter]"
                Case System.Windows.Forms.Keys.ShiftKey : s = "[Shift]"
                Case System.Windows.Forms.Keys.ControlKey : s = "[Ctrl]"
                Case System.Windows.Forms.Keys.Menu : s = "[Alt]"
                Case System.Windows.Forms.Keys.Pause : s = "[Pause]"
                Case System.Windows.Forms.Keys.Capital : s = "[CapsLock]"
                Case System.Windows.Forms.Keys.Escape : s = "[ESC]"
                Case System.Windows.Forms.Keys.Space : s = "[SPACEBAR]"
                Case System.Windows.Forms.Keys.PageUp : s = "[PAGE UP]"
                Case System.Windows.Forms.Keys.PageDown : s = "[PAGE DOWN]"
                Case System.Windows.Forms.Keys.End : s = "[END]"
                Case System.Windows.Forms.Keys.Home : s = "[HOME]"
                Case System.Windows.Forms.Keys.Left : s = "[LEFT ARROW]"
                Case System.Windows.Forms.Keys.Up : s = "[UP ARROW]"
                Case System.Windows.Forms.Keys.Right : s = "[RIGHT ARROW]"
                Case System.Windows.Forms.Keys.Down : s = "[DOWN ARROW]"
                Case System.Windows.Forms.Keys.Select : s = "[SELECT]"
                Case System.Windows.Forms.Keys.Print : s = "[PRINT SCREEN]"
                Case System.Windows.Forms.Keys.Execute : s = "[EXECUTE]"
                Case System.Windows.Forms.Keys.Snapshot : s = "[SNAPSHOT]"
                Case System.Windows.Forms.Keys.Insert : s = "[INS]"
                Case System.Windows.Forms.Keys.Delete : s = "[DEL]"
                Case System.Windows.Forms.Keys.Help : s = "[HELP]"
                Case System.Windows.Forms.Keys.NumLock : s = "[NUM LOCK]"
                Case 91 : s = "[Win]"
                Case 160 : s = "[ShiftL]"
                Case 161 : s = "[ShiftR]"
                Case 162 : s = "[CtrlL]"
                Case 163 : s = "[CtrlR]"
                Case 164 : s = "[AltL]"
                Case 165 : s = "[AltR]"
                Case System.Windows.Forms.Keys.D0 To System.Windows.Forms.Keys.D9 : s = Chr(k)
                Case System.Windows.Forms.Keys.A To System.Windows.Forms.Keys.Z
                    s = UCase(Chr(k))
                Case System.Windows.Forms.Keys.F1 To System.Windows.Forms.Keys.F16 : s = "F" & CStr(k - 111)
                Case System.Windows.Forms.Keys.NumPad0 To System.Windows.Forms.Keys.NumPad9 : s = "Numpad " & CStr(k - 95)
                Case System.Windows.Forms.Keys.Multiply : s = "[Numpad {*}]"
                Case System.Windows.Forms.Keys.Add : s = "[Numpad {+}]"
                Case System.Windows.Forms.Keys.Separator : s = "[Numpad {ENTER}]"
                Case System.Windows.Forms.Keys.Subtract : s = "[Numpad {-}]"
                Case System.Windows.Forms.Keys.Decimal : s = "[Numpad {.}]"
                Case System.Windows.Forms.Keys.Divide : s = "[Numpad {/}]"
                Case Else
                    s = k
            End Select
            CharFromKeyCode = s
        End Function

        Sub HookMouseCallback(ByVal wparam As UIntPtr, ByVal lparam As IntPtr, ByVal x As Integer, ByVal y As Integer)
            Dim ButtonPosSet As Boolean
            Try
                If wparam = 514 Then
                    If MOUSEEVENT_LEFTUP_IGNORE = False Then
                        Hook.UninstallHook(HookTypes.MouseLL)
                        ComButton.BackgroundImage = Nothing
                        Dim configxml As System.Xml.XmlDocument
                        configxml = New System.Xml.XmlDocument
                        configxml.Load(CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.ConfigPath)
                        MOUSEEVENT_LEFTUP_BOOLEAN = False
                        mouse_event(MOUSEEVENT_ABSOLUTE Or MOUSEEVENT_LEFTUP, x, y, 0, 0)
                        If CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.isFullscreen = True Then
                            ComButton.Opacity = CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_SET_FULLSCREEN_BUTTON_SHOW_OPACITY / 100
                            CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_SET_FULLSCREEN_BUTTON_TOP = ComButton.Top
                            CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_SET_FULLSCREEN_BUTTON_LEFT = ComButton.Left
                            configxml.SelectSingleNode("/APPCONFIG/FULLSCREEN/BUTTONSTOP").InnerText = ComButton.Top
                            configxml.SelectSingleNode("/APPCONFIG/FULLSCREEN/BUTTONSLEFT").InnerText = ComButton.Left
                        Else
                            ComButton.Opacity = CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_SET_SCREEN_BUTTON_SHOW_OPACITY / 100
                            CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_SET_SCREEN_BUTTON_TOP = ComButton.Top
                            CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_SET_SCREEN_BUTTON_LEFT = ComButton.Left
                            configxml.SelectSingleNode("/APPCONFIG/SCREEN/BUTTONSTOP").InnerText = ComButton.Top
                            configxml.SelectSingleNode("/APPCONFIG/SCREEN/BUTTONSLEFT").InnerText = ComButton.Left
                        End If
                        configxml.Save(CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.ConfigPath)
                        configxml = Nothing

                    Else
                        MOUSEEVENT_LEFTUP_IGNORE = False
                    End If

                Else
                    If MOUSEEVENT_LEFTUP_BOOLEAN = False Then
                        MOUSEEVENT_LEFTUP_BOOLEAN = True
                        MOUSEEVENT_LEFTUP_IGNORE = True
                        mouse_event(MOUSEEVENT_ABSOLUTE Or MOUSEEVENT_LEFTUP, x, y, 0, 0)
                    End If

                    If y - DownMouseY < CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Top Then
                        y = CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Top + DownMouseY
                        Windows.Forms.Cursor.Position = New System.Drawing.Point(x, y)
                        ComButton.Left = Windows.Forms.Cursor.Position.X - DownMouseX
                        ComButton.Top = Windows.Forms.Cursor.Position.Y - DownMouseY
                        ButtonPosSet = True
                    ElseIf y - DownMouseY + ButtonHeight > CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Top + CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Height Then
                        y = CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Top + CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Height + DownMouseY - ButtonHeight
                        Windows.Forms.Cursor.Position = New System.Drawing.Point(x, y)
                        ComButton.Left = Windows.Forms.Cursor.Position.X - DownMouseX
                        ComButton.Top = Windows.Forms.Cursor.Position.Y - DownMouseY
                        ButtonPosSet = True
                    End If

                    If x - DownMouseX < CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Left Then
                        Windows.Forms.Cursor.Position = New System.Drawing.Point(CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Left + DownMouseX, y)
                        ComButton.Left = Windows.Forms.Cursor.Position.X - DownMouseX
                        ComButton.Top = Windows.Forms.Cursor.Position.Y - DownMouseY
                        ButtonPosSet = True
                    ElseIf x - DownMouseX + ButtonWidth > CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Left + CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Width Then
                        Windows.Forms.Cursor.Position = New System.Drawing.Point(CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Left + CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Width + DownMouseX - ButtonWidth, y)
                        ComButton.Left = Windows.Forms.Cursor.Position.X - DownMouseX
                        ComButton.Top = Windows.Forms.Cursor.Position.Y - DownMouseY
                        ButtonPosSet = True
                    End If
                    If ButtonPosSet = False Then
                        ComButton.Left = x - DownMouseX
                        ComButton.Top = y - DownMouseY
                    End If

                End If

            Catch ex As Exception

            End Try
        End Sub

        Sub HookKeyboardCallback(ByVal code As Integer, ByVal wparam As UIntPtr, ByVal lparam As IntPtr)

            If wparam = 257 Or wparam = 261 Then
                'сброс
                If HotKeyShow.Enable = True Then HotKeyShow.CurentKey = 0
                If HotKeyHide.Enable = True Then HotKeyHide.CurentKey = 0
                If HotKeyFullScreen.Enable = True Then HotKeyFullScreen.CurentKey = 0
                If HotKeyAppClose.Enable = True Then HotKeyAppClose.CurentKey = 0
                If HotKeyFitWindow.Enable = True Then HotKeyFitWindow.CurentKey = 0

                If SetingHotKey = True And RecHotKey = True And HotKeyDown = True Then
                    HotKeyDown = False
                    FrmHotKey.DefInstance.BtnRec.Text = "Rec"
                    RecHotKey = False
                End If

            ElseIf wparam = 256 Or wparam = 260 Then


                If SetingHotKey = True Then
                    If RecHotKey = True And OldKeyCode <> code Then


                        If Len(FrmHotKey.DefInstance.HotKeyTxt.Text) = 0 Then
                            FrmHotKey.DefInstance.HotKeyTxt.Text = CharFromKeyCode(code)
                            HotKeyCom = CStr(code)
                            HotKeyDown = True
                        Else
                            FrmHotKey.DefInstance.HotKeyTxt.Text = FrmHotKey.DefInstance.HotKeyTxt.Text & "+" & CharFromKeyCode(code)
                            HotKeyCom = HotKeyCom & "+" & CStr(code)
                        End If

                        OldKeyCode = code

                    End If
                Else
                    If HotKeyShow.Enable = True Then
                        If code = HotKeyShow.Key(HotKeyShow.CurentKey) Then
                            If UBound(HotKeyShow.Key) > HotKeyShow.CurentKey Then
                                HotKeyShow.CurentKey = HotKeyShow.CurentKey + 1
                            Else
                                CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_Show()
                                If HotKeyShow.Enable = True Then HotKeyShow.CurentKey = 0
                                If HotKeyHide.Enable = True Then HotKeyHide.CurentKey = 0
                                If HotKeyFullScreen.Enable = True Then HotKeyFullScreen.CurentKey = 0
                                If HotKeyAppClose.Enable = True Then HotKeyAppClose.CurentKey = 0
                                If HotKeyFitWindow.Enable = True Then HotKeyFitWindow.CurentKey = 0
                            End If
                        Else
                            HotKeyShow.CurentKey = 0
                        End If
                    End If

                    If HotKeyHide.Enable = True Then
                        If code = HotKeyHide.Key(HotKeyHide.CurentKey) Then
                            If UBound(HotKeyHide.Key) > HotKeyHide.CurentKey Then
                                HotKeyHide.CurentKey = HotKeyHide.CurentKey + 1
                            Else
                                CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_Hide()
                                If HotKeyShow.Enable = True Then HotKeyShow.CurentKey = 0
                                If HotKeyHide.Enable = True Then HotKeyHide.CurentKey = 0
                                If HotKeyFullScreen.Enable = True Then HotKeyFullScreen.CurentKey = 0
                                If HotKeyAppClose.Enable = True Then HotKeyAppClose.CurentKey = 0
                                If HotKeyFitWindow.Enable = True Then HotKeyFitWindow.CurentKey = 0
                            End If
                        Else
                            HotKeyHide.CurentKey = 0
                        End If
                    End If

                    If HotKeyFullScreen.Enable = True Then
                        If code = HotKeyFullScreen.Key(HotKeyFullScreen.CurentKey) Then
                            If UBound(HotKeyFullScreen.Key) > HotKeyFullScreen.CurentKey Then
                                HotKeyFullScreen.CurentKey = HotKeyFullScreen.CurentKey + 1
                            Else
                                CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.Screen()
                                If HotKeyShow.Enable = True Then HotKeyShow.CurentKey = 0
                                If HotKeyHide.Enable = True Then HotKeyHide.CurentKey = 0
                                If HotKeyFullScreen.Enable = True Then HotKeyFullScreen.CurentKey = 0
                                If HotKeyAppClose.Enable = True Then HotKeyAppClose.CurentKey = 0
                                If HotKeyFitWindow.Enable = True Then HotKeyFitWindow.CurentKey = 0
                            End If
                        Else
                            HotKeyFullScreen.CurentKey = 0
                        End If
                    End If

                    If HotKeyAppClose.Enable = True Then
                        If code = HotKeyAppClose.Key(HotKeyAppClose.CurentKey) Then
                            If UBound(HotKeyAppClose.Key) > HotKeyAppClose.CurentKey Then
                                HotKeyAppClose.CurentKey = HotKeyAppClose.CurentKey + 1
                            Else
                                If HotKeyShow.Enable = True Then HotKeyShow.CurentKey = 0
                                If HotKeyHide.Enable = True Then HotKeyHide.CurentKey = 0
                                If HotKeyFullScreen.Enable = True Then HotKeyFullScreen.CurentKey = 0
                                If HotKeyAppClose.Enable = True Then HotKeyAppClose.CurentKey = 0
                                If HotKeyFitWindow.Enable = True Then HotKeyFitWindow.CurentKey = 0
                                CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.FSP_SHUTDOWN()
                            End If
                        Else
                            HotKeyAppClose.CurentKey = 0
                        End If
                    End If

                    If HotKeyFitWindow.Enable = True Then
                        If code = HotKeyFitWindow.Key(HotKeyFitWindow.CurentKey) Then
                            If UBound(HotKeyFitWindow.Key) > HotKeyFitWindow.CurentKey Then
                                HotKeyFitWindow.CurentKey = HotKeyFitWindow.CurentKey + 1
                            Else
                                If HotKeyShow.Enable = True Then HotKeyShow.CurentKey = 0
                                If HotKeyHide.Enable = True Then HotKeyHide.CurentKey = 0
                                If HotKeyFullScreen.Enable = True Then HotKeyFullScreen.CurentKey = 0
                                If HotKeyAppClose.Enable = True Then HotKeyAppClose.CurentKey = 0
                                If HotKeyFitWindow.Enable = True Then HotKeyFitWindow.CurentKey = 0
                                CF_Full_Screen_Programm.FullScreenProgramm.Full_Screen_Programm.GetInstance.UpdateWindow()
                            End If
                        Else
                            HotKeyShow.CurentKey = 0
                        End If
                    End If

                End If
            End If

        End Sub

        Public Sub InitHookMouse(ByVal type As HookTypes)
            _processHandlerMouse = New HookProcessedHandler(AddressOf InternalHookCallbackMouse)
            Dim result As SetCallBackResults = Hook.SetUserHookCallback(_processHandlerMouse, type)

        End Sub
        Public Sub InstallHookMouse(ByVal type As HookTypes)
            Hook.InitializeHook(type, 0)
            _isHooked = True
        End Sub


        Public Sub InstallHookKeyboard(ByVal type As HookTypes)
            _processHandlerKeyboard = New HookProcessedHandler(AddressOf InternalHookKeyboardCallback)
            Dim result As SetCallBackResults = Hook.SetUserHookCallback(_processHandlerKeyboard, type)
            Hook.InitializeHook(type, 0)
            _isHooked = True
        End Sub

        <MethodImpl(MethodImplOptions.NoInlining)> _
        Private Sub InternalHookCallbackMouse(ByVal code As Integer, ByVal wparam As UIntPtr, ByVal lparam As IntPtr)
            Dim x As Integer = 0
            Dim y As Integer = 0
            Try
                Hook.InternalGetMousePosition(wparam, lparam, x, y)
                HookMouseCallback(wparam, lparam, x, y)
            Catch e As Exception
                Debug.WriteLine(("Exception during hook callback: " & e.Message & " " & e.ToString))
            End Try
        End Sub



        <MethodImpl(MethodImplOptions.NoInlining)> _
        Private Sub InternalHookKeyboardCallback(ByVal code As Integer, ByVal wparam As UIntPtr, ByVal lparam As IntPtr)
            Dim vkCode As Integer = 0
            Try
                Hook.IntenralGetKeyboardReading(wparam, lparam, vkCode)
                HookKeyboardCallback(vkCode, wparam, lparam)
            Catch e As Exception
                Debug.WriteLine(("Exception during hook callback: " & e.Message & " " & e.ToString))
            End Try
        End Sub



        Public Sub UninstallHook(ByVal type As HookTypes)
            _isHooked = False
            Hook.UninitializeHook(type)
        End Sub




    End Module
End Namespace