/*
SndVolduino project.
Code by Giordano Bruno (GiordanoFilippoBruno at domain gmail.com)
*/

#include <windows.h>
#include "com_tiny.h"
#include "Volume.h"
#include "cmdlineargs.h"
#include "math.h"

HANDLE hPort;
CVolume Volumes[6];
int LineNumbers[6] = {-1, -1, -1, -1, -1, -1};

#define ATOI2_ERROR (-1)
int atoi2(char* str) {
	char* pTmp;
	int a = strtol(str, &pTmp, 10);
	if (pTmp == str) a = ATOI2_ERROR;
	return a;
}

int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nFunsterStil)

{
	int raw, num, vol, i;
	char buf[256];
	bool bNoErr;

	CmdLineArgs args;
	if (args.size() < 3) {
		MessageBox(NULL,
			"USAGE: SndVolduino.exe <COM-port> <Line0> [Line1] [Line2] [Line3] [Line4] [Line5]\n"
			"where COM-port is \"COMn\" or \"\\\\.\\COMnn\"\n"
			"Line[0..5] is sound line, corresponding to ADC channel number\n"
			"put here \"x\"\ to skip ADC channel \n"
			"EXAMPLES:\n"
			"SndVolduino.exe COM3 1 2 3\n"
			"SndVolduino.exe \\\\.\\COM13 x x x 3 2 1",
			"Help", 0);
	} else {
		for (i=2; i<args.size(); i++) {
			LineNumbers[i-2] = atoi2(args[i]);
		}
	}

	for (i=0; i<6; i++) {
		if (LineNumbers[i] != -1) {
			Volumes[i].Open(NULL, LineNumbers[i]);
		}
	}

	while (true) {
		//open port
		hPort = com_InitPort(args[1], 115200);
		//wait for arduino to boot
		Sleep(2000);
		//if port opend successfully
		if (hPort != INVALID_HANDLE_VALUE) {
			//repeat reading lines
			do {
				bNoErr = com_ReadLine(hPort, buf, sizeof(buf));	//read line
				if (bNoErr) {	//if it's read successfully
					//get ADC channel number and volume level
					raw = atoi(buf);
					num = raw >> 10;
					vol = (int)floor((raw & 0x3ff)*65535.0/1023);
					//if this channel have corresponding line, set sound volume
					if (LineNumbers[num] != -1) {
						Volumes[num].SetVolume(vol);
					}
				}
			} while (bNoErr); //untill error occures
			com_ClosePort(hPort);	//close port (after error)
		}
		//if there was error openning port - will try again
	}
    return 0;
}
